<?php
session_start();
header('Content-Type: application/json; charset=utf-8');

// دریافت داده از بدنه درخواست
$input = json_decode(file_get_contents('php://input'), true);

// بررسی داده ورودی
if (!$input || !isset($input['id']) || !isset($input['delta'])) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'داده‌های ورودی نامعتبر است']);
    exit;
}

$id = (int)$input['id'];
$delta = (int)$input['delta'];

// اگر سبد خرید وجود ندارد، بساز
if (!isset($_SESSION['cart']) || !is_array($_SESSION['cart'])) {
    $_SESSION['cart'] = [];
}

// جستجو برای محصول مورد نظر
$found = false;
foreach ($_SESSION['cart'] as &$item) {
    if (isset($item['id']) && (int)$item['id'] === $id) {
        $item['qty'] = max(1, (int)$item['qty'] + $delta);
        $found = true;
        break;
    }
}
unset($item); // جلوگیری از ارجاع ناخواسته به آخرین المنت آرایه

// در صورت عدم یافتن محصول، پیام مناسب بده
if (!$found) {
    http_response_code(404);
    echo json_encode(['ok' => false, 'error' => 'محصول در سبد خرید یافت نشد']);
    exit;
}

// بازگرداندن وضعیت جدید سبد خرید
echo json_encode([
    'ok' => true,
    'cart' => $_SESSION['cart']
], JSON_UNESCAPED_UNICODE);
?>
