<?php
// server/contact.php — نسخه اصلاح‌شده و امن‌تر

$config = include __DIR__ . '/config.php';
header('Content-Type: application/json; charset=utf-8');

// فقط درخواست‌های POST مجازند
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

// دریافت و تمیز کردن ورودی‌ها
$name    = trim($_POST['name'] ?? '');
$email   = trim($_POST['email'] ?? '');
$message = trim($_POST['message'] ?? '');

// بررسی صحت ورودی‌ها
if ($name === '' || $message === '' || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
    http_response_code(400);
    echo json_encode(['error' => 'لطفاً همه فیلدها را به درستی پر کنید.']);
    exit;
}

// بررسی reCAPTCHA در صورت نیاز
if (!empty($config['recaptcha_secret']) && isset($_POST['g-recaptcha-response'])) {
    $resp = @file_get_contents('https://www.google.com/recaptcha/api/siteverify?secret=' .
        urlencode($config['recaptcha_secret']) . '&response=' . urlencode($_POST['g-recaptcha-response']));
    
    if (!$resp) {
        http_response_code(500);
        echo json_encode(['error' => 'عدم ارتباط با سرور reCAPTCHA']);
        exit;
    }

    $data = json_decode($resp, true);
    if (empty($data['success'])) {
        http_response_code(400);
        echo json_encode(['error' => 'اعتبارسنجی reCAPTCHA ناموفق بود.']);
        exit;
    }
}

// ساخت ایمیل
$to       = $config['contact_to'] ?? 'info@parsa-stationery.ir';
$subject  = "پیام از فرم تماس - {$name}";
$body     = "نام: {$name}\nایمیل: {$email}\n\nپیام:\n{$message}";
$headers  = "From: no-reply@parsa-stationery.ir\r\n" .
             "Reply-To: {$email}\r\n" .
             "Content-Type: text/plain; charset=utf-8";

// ارسال با PHPMailer (در صورت فعال بودن)
if (!empty($config['use_phpmailer'])) {
    if (file_exists(__DIR__ . '/vendor/autoload.php')) {
        require __DIR__ . '/vendor/autoload.php';
        $mail = new PHPMailer\PHPMailer\PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->Host       = $config['smtp']['host'] ?? '';
            $mail->Port       = $config['smtp']['port'] ?? 587;
            $mail->Username   = $config['smtp']['username'] ?? '';
            $mail->Password   = $config['smtp']['password'] ?? '';
            $mail->SMTPSecure = $config['smtp']['secure'] ?? 'tls';
            $mail->SMTPAuth   = true;

            $mail->setFrom('no-reply@parsa-stationery.ir', 'فروشگاه پارسا');
            $mail->addAddress($to);
            $mail->addReplyTo($email, $name);
            $mail->Subject = $subject;
            $mail->Body    = $body;
            $mail->send();

            echo json_encode(['ok' => true, 'message' => 'پیام شما با موفقیت ارسال شد.']);
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['error' => 'خطا در ارسال ایمیل: ' . $e->getMessage()]);
        }
        exit;
    }
}

// ارسال با mail() در صورت نبود PHPMailer
if (@mail($to, $subject, $body, $headers)) {
    echo json_encode(['ok' => true, 'message' => 'پیام شما با موفقیت ارسال شد.']);
} else {
    http_response_code(500);
    echo json_encode(['error' => 'ارسال ایمیل با خطا مواجه شد.']);
}
?>
