<?php
session_start();
header('Content-Type: application/json; charset=utf-8');

// بارگذاری تنظیمات
$config = include __DIR__ . '/config.php';

// مسیر فایل سفارش‌ها
$ordersFile = $config['orders_file'] ?? __DIR__ . '/orders.json';

// خواندن سبد خرید
$cart = $_SESSION['cart'] ?? [];

// اگر سبد خالی است
if (empty($cart)) {
    http_response_code(400);
    echo json_encode(['error' => 'empty cart']);
    exit;
}

// بررسی ساختار هر آیتم برای اطمینان از صحت داده‌ها
foreach ($cart as $item) {
    if (!isset($item['id'], $item['title'], $item['price'], $item['qty'])) {
        http_response_code(400);
        echo json_encode(['error' => 'invalid cart data']);
        exit;
    }
}

// ساخت سفارش
$order = [
    'id'      => uniqid('order_', true),
    'created' => date('c'),
    'items'   => $cart,
    'total'   => array_sum(array_map(fn($i) => $i['price'] * $i['qty'], $cart)),
];

// خواندن سفارش‌های قبلی
$orders = [];
if (file_exists($ordersFile)) {
    $data = file_get_contents($ordersFile);
    $orders = json_decode($data, true) ?: [];
}

// اضافه کردن سفارش جدید
$orders[] = $order;

// ذخیره امن سفارش‌ها
if (file_put_contents($ordersFile, json_encode($orders, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)) === false) {
    http_response_code(500);
    echo json_encode(['error' => 'cannot save order']);
    exit;
}

// خالی کردن سبد خرید
$_SESSION['cart'] = [];

// پاسخ موفق
echo json_encode([
    'ok'    => true,
    'order' => $order
], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
?>
