
// Secure frontend: tries server endpoints under /server/* and falls back to localStorage if server unavailable.
function q(sel){return document.querySelector(sel)}
function formatPrice(n){return n.toLocaleString()}

let serverAvailable = false;
async function pingServer(){
  try{
    const res = await fetch('server/ping.php',{cache:'no-store'});
    if(res.ok){ serverAvailable = true; }
  }catch(e){ serverAvailable = false; }
}
async function serverAddToCart(id){
  try{
    const r = await fetch('server/add_to_cart.php', {method:'POST', headers:{'Content-Type':'application/json'}, body:JSON.stringify({id:id,qty:1})});
    return r.ok;
  }catch(e){return false;}
}

/////////////////////////////////
// local fallback cart (same shape)
function getLocalCart(){ return JSON.parse(localStorage.getItem('parsa_cart')||'[]'); }
function saveLocalCart(c){ localStorage.setItem('parsa_cart', JSON.stringify(c)); }
function localAddToCart(id){
  const p = PRODUCTS.find(x=>x.id===id); if(!p) return false;
  const c = getLocalCart(); const it = c.find(i=>i.id===id);
  if(it) it.qty++; else c.push({id:p.id,title:p.title,price:p.price,qty:1});
  saveLocalCart(c); return true;
}

async function addToCart(id){
  if(serverAvailable){
    const ok = await serverAddToCart(id);
    if(ok){ alert('محصول به سبد اضافه شد (سروری)'); refreshCartCount(); return; }
  }
  const lres = localAddToCart(id);
  if(lres){ alert('محصول به سبد اضافه شد (محلی)'); refreshCartCount(); } else alert('خطا در افزودن محصول');
}

async function refreshCartCount(){
  if(serverAvailable){
    try{
      const r = await fetch('server/get_cart.php',{cache:'no-store'});
      if(r.ok){ const data = await r.json(); const c = data.reduce((s,i)=>s+i.qty,0); document.getElementById('cart-count').textContent = c; return; }
    }catch(e){}
  }
  const c = getLocalCart().reduce((s,i)=>s+i.qty,0); document.getElementById('cart-count').textContent = c;
}

// Render products
function renderGrid(targetId, list){
  const el = document.getElementById(targetId); if(!el) return; el.innerHTML='';
  list.forEach(p=>{
    const card = document.createElement('div'); card.className='product-card';
    card.innerHTML = `<img src="${p.img}" alt="${p.title}"><h4>${p.title}</h4><p class="muted">${p.desc}</p>
      <div class="card-actions">
        <a class="btn outline" href="product.html?id=${p.id}">🔍 مشاهده محصول</a>
        <button class="btn neon" onclick="addToCart(${p.id})">🛒 افزودن به سبد</button>
      </div>`;
    el.appendChild(card);
  });
}

// Product detail
function renderProductDetail(){
  const wrapper = document.getElementById('productWrapper'); if(!wrapper) return;
  const params = new URLSearchParams(location.search); const id = parseInt(params.get('id'));
  const p = PRODUCTS.find(x=>x.id===id); if(!p){ wrapper.innerHTML='<p>محصول یافت نشد.</p>'; return; }
  wrapper.innerHTML = `<div class="product-detail-card">
    <div style="display:flex;gap:20px;flex-wrap:wrap">
      <img src="${p.img}" alt="${p.title}" style="width:360px;border-radius:10px;">
      <div style="flex:1">
        <h2>${p.title}</h2><p class="muted">${p.desc}</p>
        <p class="price">${formatPrice(p.price)} تومان</p>
        <div style="margin-top:16px"><button class="btn neon" onclick="addToCart(${p.id})">افزودن به سبد</button></div>
      </div>
    </div>
    <div style="margin-top:20px"><h3>نظرات کاربران</h3><p class="muted">بخش نظرات در نسخه ساده نمایشی است.</p></div>
  </div>`;
}

// Cart page render (tries server then local)
async function renderCartPage(){
  const cartContents = document.getElementById('cartContents'); if(!cartContents) return;
  let items = [];
  if(serverAvailable){
    try{
      const r = await fetch('server/get_cart.php',{cache:'no-store'});
      if(r.ok) items = await r.json();
    }catch(e){ items = []; }
  } else items = getLocalCart();
  cartContents.innerHTML='';
  let total=0;
  items.forEach(it=>{ total += it.price*it.qty;
    const div = document.createElement('div'); div.className='cart-item';
    div.innerHTML = `<div style="flex:1"><strong>${it.title}</strong><div class="muted">${formatPrice(it.price)} تومان</div></div>
      <div style="display:flex;gap:6px;align-items:center">
        <button class="btn outline" onclick="changeQty(${it.id},-1)">-</button>
        <div>${it.qty}</div>
        <button class="btn outline" onclick="changeQty(${it.id},1)">+</button>
        <button class="btn" onclick="removeFromCart(${it.id})">حذف</button>
      </div>`;
    cartContents.appendChild(div);
  });
  document.getElementById('cartTotalCart').textContent = formatPrice(total);
}

// change qty/remove (server + local)
async function changeQty(id,delta){
  if(serverAvailable){
    try{ await fetch('server/update_cart.php',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({id:id,delta:delta})}); refreshCartCount(); if(location.pathname.endsWith('cart.html')) renderCartPage(); return; }catch(e){}
  }
  const c = getLocalCart(); const it = c.find(x=>x.id===id); if(!it) return;
  it.qty = Math.max(1, it.qty + delta); saveLocalCart(c); refreshCartCount(); if(location.pathname.endsWith('cart.html')) renderCartPage();
}
async function removeFromCart(id){
  if(serverAvailable){
    try{ await fetch('server/remove_from_cart.php',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({id:id})}); refreshCartCount(); if(location.pathname.endsWith('cart.html')) renderCartPage(); return; }catch(e){}
  }
  const c = getLocalCart().filter(x=>x.id!==id); saveLocalCart(c); refreshCartCount(); if(location.pathname.endsWith('cart.html')) renderCartPage();
}

// Starfield (same as before)
function initStarfield(){
  const canvas = document.getElementById('star-canvas'); if(!canvas) return;
  const ctx = canvas.getContext('2d'); let w=canvas.width=innerWidth, h=canvas.height=innerHeight;
  window.addEventListener('resize',()=>{w=canvas.width=innerWidth;h=canvas.height=innerHeight;});
  const stars=[]; for(let i=0;i<220;i++) stars.push({x:Math.random()*w,y:Math.random()*h,sz:Math.random()*1.2+0.2,dx:(Math.random()-0.5)*0.2});
  function draw(){ ctx.clearRect(0,0,w,h); for(const s of stars){ ctx.beginPath(); const g=ctx.createRadialGradient(s.x,s.y,0,s.x,s.y,s.sz*6); g.addColorStop(0,'rgba(255,255,255,0.8)'); g.addColorStop(1,'rgba(100,120,255,0)'); ctx.fillStyle=g; ctx.fillRect(s.x,s.y,s.sz,s.sz); } for(const s of stars){ s.x+=s.dx; if(s.x<0) s.x=w; if(s.x>w) s.x=0; } requestAnimationFrame(draw); } draw();
}

// Init
window.addEventListener('load', async ()=>{
  await pingServer();
  initStarfield();
  renderGrid('productsGrid', PRODUCTS.slice(0,4));
  renderGrid('productsGridAll', PRODUCTS);
  refreshCartCount();
  // filters
  const sb = document.getElementById('searchBox'); const cf = document.getElementById('categoryFilter');
  if(sb) sb.addEventListener('input',()=>{ applyFilters('productsGrid', sb, cf); });
  const sbp = document.getElementById('searchBoxProducts'); const cfp = document.getElementById('categoryFilterProducts');
  if(sbp) sbp.addEventListener('input',()=>{ applyFilters('productsGridAll', sbp, cfp); });
  // product detail
  renderProductDetail();
  // cart page
  if(location.pathname.endsWith('cart.html')) renderCartPage();
  // cart panel toggle
  const cartBtn=document.getElementById('cartBtn'); const cartPanel=document.getElementById('cartPanel'); const closeCart=document.getElementById('closeCart');
  if(cartBtn && cartPanel){ cartBtn.addEventListener('click',()=>cartPanel.classList.add('open')); }
  if(closeCart) closeCart.addEventListener('click',()=>cartPanel.classList.remove('open'));
});

function applyFilters(target, qbox, select){ const q = (qbox && qbox.value)? qbox.value.trim().toLowerCase(): ''; const cat = (select && select.value)? select.value : 'all'; const filtered = PRODUCTS.filter(p=> (cat==='all' || p.category===cat) && (p.title.toLowerCase().includes(q) || p.desc.toLowerCase().includes(q))); renderGrid(target, filtered); }
