<?php
session_start();
header('Content-Type: application/json; charset=utf-8');

// دریافت ورودی JSON
$input = json_decode(file_get_contents('php://input'), true);

// بررسی صحت داده ورودی
if (!$input || !isset($input['id'])) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'شناسه محصول ارسال نشده است']);
    exit;
}

$id = (int)$input['id'];

// بررسی وجود سبد خرید در سشن
if (!isset($_SESSION['cart']) || !is_array($_SESSION['cart'])) {
    $_SESSION['cart'] = [];
}

// حذف محصول با id مشخص‌شده
$_SESSION['cart'] = array_values(array_filter($_SESSION['cart'], function($item) use ($id) {
    return isset($item['id']) && (int)$item['id'] !== $id;
}));

// پاسخ موفق
echo json_encode([
    'ok' => true,
    'cart' => $_SESSION['cart']
], JSON_UNESCAPED_UNICODE);
?>
