<?php
// config.php — تنظیمات فروشگاه لوازم‌التحریر پارسا

return [

    // 📦 فایل ذخیره سفارش‌ها
    'orders_file' => __DIR__ . '/orders.json',

    // 🔒 reCAPTCHA secret key (در صورت نیاز)
    'recaptcha_secret' => getenv('RECAPTCHA_SECRET') ?: '',

    // 📧 ایمیل مقصد فرم تماس
    'contact_to' => getenv('CONTACT_TO') ?: 'info@parsa-stationery.ir',

    // 📤 استفاده از PHPMailer برای ارسال ایمیل
    'use_phpmailer' => false,

    //⚙️ تنظیمات SMTP (درصورت استفاده از PHPMailer)
    'smtp' => [
        'host' => getenv('SMTP_HOST') ?: 'smtp.example.com',
        'port' => getenv('SMTP_PORT') ?: 587,
        'username' => getenv('SMTP_USER') ?: '',
        'password' => getenv('SMTP_PASS') ?: '',
        'secure' => 'tls' // یا 'ssl'
    ],

    // 🧾 تنظیمات عمومی
    'site_name' => 'فروشگاه لوازم‌التحریر پارسا',
    'currency' => 'تومان',

];
?>
