<?php
session_start();
header('Content-Type: application/json; charset=utf-8');

$input = json_decode(file_get_contents('php://input'), true);

// بررسی ورودی
if (!$input || !isset($input['id'])) {
    http_response_code(400);
    echo json_encode(['error' => 'invalid input']);
    exit;
}

$id  = (int)$input['id'];
$qty = isset($input['qty']) ? (int)$input['qty'] : 1;

// جلوگیری از مقادیر غیرمجاز
if ($id <= 0 || $qty < 1) {
    http_response_code(400);
    echo json_encode(['error' => 'invalid values']);
    exit;
}

// محدودیت تعداد (برای جلوگیری از پر شدن سشن)
if ($qty > 50) $qty = 50;

// آماده‌سازی سبد خرید
if (!isset($_SESSION['cart'])) {
    $_SESSION['cart'] = [];
}

// فرضاً در فایل data.json محصولات معتبر ذخیره شده‌اند
// (اینجا به‌صورت نمونه داده ثابت)
$products = [
    1 => ['title' => 'دفتر 100 برگ', 'price' => 35000],
    2 => ['title' => 'خودکار آبی', 'price' => 12000],
    3 => ['title' => 'پاک‌کن طرح فانتزی', 'price' => 8000],
];

if (!isset($products[$id])) {
    http_response_code(404);
    echo json_encode(['error' => 'product not found']);
    exit;
}

$found = false;
foreach ($_SESSION['cart'] as &$item) {
    if ($item['id'] === $id) {
        $item['qty'] += $qty;
        $found = true;
        break;
    }
}

if (!$found) {
    $_SESSION['cart'][] = [
        'id'    => $id,
        'title' => $products[$id]['title'],
        'price' => $products[$id]['price'],
        'qty'   => $qty
    ];
}

echo json_encode([
    'ok'   => true,
    'cart' => $_SESSION['cart']
], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
?>
